#include "Animal.hpp"
#include "Dog.hpp"
#include "Cat.hpp"
#include "WrongAnimal.hpp"
#include "WrongCat.hpp"

int main() {
    std::cout << "=== Basic Polymorphism Tests ===" << std::endl;
    std::cout << std::endl;

    const Animal* meta = new Animal();
    const Animal* j = new Dog();
    const Animal* i = new Cat();

    std::cout << std::endl;
    std::cout << "Type of j: " << j->getType() << std::endl;
    std::cout << "Type of i: " << i->getType() << std::endl;
    std::cout << "Type of meta: " << meta->getType() << std::endl;

    std::cout << std::endl;
    std::cout << "=== Sound Tests (with virtual) ===" << std::endl;
    i->makeSound();      // Will output Cat sound
    j->makeSound();      // Will output Dog sound
    meta->makeSound();   // Will output generic Animal sound

    std::cout << std::endl;
    std::cout << "=== Cleanup ===" << std::endl;
    delete meta;
    delete j;
    delete i;

    std::cout << std::endl;
    std::cout << "========================================" << std::endl;
    std::cout << "=== Wrong Animal Tests (no virtual) ===" << std::endl;
    std::cout << "========================================" << std::endl;
    std::cout << std::endl;

    const WrongAnimal* wrongMeta = new WrongAnimal();
    const WrongAnimal* wrongCat = new WrongCat();

    std::cout << std::endl;
    std::cout << "Type of wrongCat: " << wrongCat->getType() << std::endl;
    std::cout << "Type of wrongMeta: " << wrongMeta->getType() << std::endl;

    std::cout << std::endl;
    std::cout << "=== Sound Tests (without virtual) ===" << std::endl;
    wrongCat->makeSound();   // Will output WrongAnimal sound (NOT WrongCat!)
    wrongMeta->makeSound();  // Will output WrongAnimal sound

    std::cout << std::endl;
    std::cout << "=== Direct WrongCat object test ===" << std::endl;
    WrongCat directCat;
    std::cout << std::endl;
    directCat.makeSound();   // Will output WrongCat sound (called directly)

    std::cout << std::endl;
    std::cout << "=== Cleanup ===" << std::endl;
    delete wrongMeta;
    delete wrongCat;

    std::cout << std::endl;
    std::cout << "=== Copy Constructor Test ===" << std::endl;
    Dog originalDog;
    Dog copiedDog(originalDog);
    std::cout << "Original type: " << originalDog.getType() << std::endl;
    std::cout << "Copied type: " << copiedDog.getType() << std::endl;

    std::cout << std::endl;
    return 0;
}
