#include <iostream>
#include <cstdlib>
#include <ctime>
#include <exception>
#include "Base.hpp"
#include "A.hpp"
#include "B.hpp"
#include "C.hpp"

Base* generate(void)
{
	int random = std::rand() % 3;
	switch (random)
	{
		case 0:
			std::cout << "Generated: A" << std::endl;
			return new A();
		case 1:
			std::cout << "Generated: B" << std::endl;
			return new B();
		default:
			std::cout << "Generated: C" << std::endl;
			return new C();
	}
}

void identify(Base* p)
{
	if (dynamic_cast<A*>(p))
		std::cout << "A" << std::endl;
	else if (dynamic_cast<B*>(p))
		std::cout << "B" << std::endl;
	else if (dynamic_cast<C*>(p))
		std::cout << "C" << std::endl;
	else
		std::cout << "Unknown type" << std::endl;
}

void identify(Base& p)
{
	try
	{
		(void)dynamic_cast<A&>(p);
		std::cout << "A" << std::endl;
		return;
	}
	catch (std::exception&) {}

	try
	{
		(void)dynamic_cast<B&>(p);
		std::cout << "B" << std::endl;
		return;
	}
	catch (std::exception&) {}

	try
	{
		(void)dynamic_cast<C&>(p);
		std::cout << "C" << std::endl;
		return;
	}
	catch (std::exception&) {}

	std::cout << "Unknown type" << std::endl;
}

int main()
{
	std::srand(static_cast<unsigned int>(std::time(NULL)));

	std::cout << "=== Test 1: Generate and identify ===" << std::endl;
	for (int i = 0; i < 5; i++)
	{
		std::cout << std::endl << "--- Instance " << i + 1 << " ---" << std::endl;
		Base* ptr = generate();
		std::cout << "Identify by pointer: ";
		identify(ptr);
		std::cout << "Identify by reference: ";
		identify(*ptr);
		delete ptr;
	}

	std::cout << std::endl << "=== Test 2: Direct type tests ===" << std::endl;
	
	A* a = new A();
	B* b = new B();
	C* c = new C();

	std::cout << std::endl << "Testing A object:" << std::endl;
	std::cout << "By pointer: ";
	identify(a);
	std::cout << "By reference: ";
	identify(*a);

	std::cout << std::endl << "Testing B object:" << std::endl;
	std::cout << "By pointer: ";
	identify(b);
	std::cout << "By reference: ";
	identify(*b);

	std::cout << std::endl << "Testing C object:" << std::endl;
	std::cout << "By pointer: ";
	identify(c);
	std::cout << "By reference: ";
	identify(*c);

	delete a;
	delete b;
	delete c;

	return 0;
}
