/* ************************************************************************** */
/*                                                                            */
/*                                                        :::      ::::::::   */
/*   main.cpp                                           :+:      :+:    :+:   */
/*                                                    +:+ +:+         +:+     */
/*   By: student <student@42.fr>                    +#+  +:+       +#+        */
/*                                                +#+#+#+#+#+   +#+           */
/*   Created: 2024/01/01 00:00:00 by student           #+#    #+#             */
/*   Updated: 2024/01/01 00:00:00 by student          ###   ########.fr       */
/*                                                                            */
/* ************************************************************************** */

#include "easyfind.hpp"
#include <iostream>
#include <vector>
#include <list>
#include <deque>

int main()
{
	std::cout << "=== Testing with std::vector ===" << std::endl;
	{
		std::vector<int> vec;
		for (int i = 0; i < 10; ++i)
			vec.push_back(i * 2);

		std::cout << "Vector contents: ";
		for (std::vector<int>::iterator it = vec.begin(); it != vec.end(); ++it)
			std::cout << *it << " ";
		std::cout << std::endl;

		try
		{
			std::vector<int>::iterator it = easyfind(vec, 6);
			std::cout << "Found 6 at position: " << std::distance(vec.begin(), it) << std::endl;
		}
		catch (std::exception& e)
		{
			std::cout << "Exception: " << e.what() << std::endl;
		}

		try
		{
			std::vector<int>::iterator it = easyfind(vec, 42);
			std::cout << "Found 42 at position: " << std::distance(vec.begin(), it) << std::endl;
		}
		catch (std::exception& e)
		{
			std::cout << "Exception: " << e.what() << std::endl;
		}
	}

	std::cout << std::endl << "=== Testing with std::list ===" << std::endl;
	{
		std::list<int> lst;
		for (int i = 0; i < 5; ++i)
			lst.push_back(i + 100);

		std::cout << "List contents: ";
		for (std::list<int>::iterator it = lst.begin(); it != lst.end(); ++it)
			std::cout << *it << " ";
		std::cout << std::endl;

		try
		{
			std::list<int>::iterator it = easyfind(lst, 102);
			std::cout << "Found 102 in list" << std::endl;
			(void)it;
		}
		catch (std::exception& e)
		{
			std::cout << "Exception: " << e.what() << std::endl;
		}

		try
		{
			std::list<int>::iterator it = easyfind(lst, 999);
			std::cout << "Found 999 in list" << std::endl;
			(void)it;
		}
		catch (std::exception& e)
		{
			std::cout << "Exception: " << e.what() << std::endl;
		}
	}

	std::cout << std::endl << "=== Testing with std::deque ===" << std::endl;
	{
		std::deque<int> deq;
		deq.push_back(10);
		deq.push_back(20);
		deq.push_back(30);
		deq.push_front(5);
		deq.push_front(1);

		std::cout << "Deque contents: ";
		for (std::deque<int>::iterator it = deq.begin(); it != deq.end(); ++it)
			std::cout << *it << " ";
		std::cout << std::endl;

		try
		{
			std::deque<int>::iterator it = easyfind(deq, 20);
			std::cout << "Found 20 at position: " << std::distance(deq.begin(), it) << std::endl;
		}
		catch (std::exception& e)
		{
			std::cout << "Exception: " << e.what() << std::endl;
		}

		try
		{
			std::deque<int>::iterator it = easyfind(deq, 1);
			std::cout << "Found 1 at position: " << std::distance(deq.begin(), it) << std::endl;
		}
		catch (std::exception& e)
		{
			std::cout << "Exception: " << e.what() << std::endl;
		}
	}

	std::cout << std::endl << "=== Testing with empty container ===" << std::endl;
	{
		std::vector<int> empty;
		try
		{
			std::vector<int>::iterator it = easyfind(empty, 0);
			std::cout << "Found 0 in empty container" << std::endl;
			(void)it;
		}
		catch (std::exception& e)
		{
			std::cout << "Exception: " << e.what() << std::endl;
		}
	}

	return 0;
}
